/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blocks;

import com.github.teamfusion.rottencreatures.common.level.entities.PrimedTntBarrel;
import com.github.teamfusion.rottencreatures.core.mixin.access.FireworkRocketEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TntBarrelBlock
extends Block {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public TntBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState onState, boolean bl) {
        if (onState.is(state.getBlock())) {
            return;
        }
        if (level.hasNeighborSignal(pos)) {
            TntBarrelBlock.explode(level, pos, true);
            level.removeBlock(pos, false);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos newPos, boolean bl) {
        if (level.hasNeighborSignal(pos)) {
            level.removeBlock(pos, false);
            TntBarrelBlock.explode(level, pos, true);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && !player.isCreative() && ((Boolean)state.getValue((Property)UNSTABLE)).booleanValue()) {
            TntBarrelBlock.explode(level, pos, false);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide) {
            PrimedTntBarrel tnt = TntBarrelBlock.createPrimedTntBarrel(level, pos, explosion.getIndirectSourceEntity());
            tnt.setFuse((short)(level.random.nextInt(tnt.getFuse() / 4) + tnt.getFuse() / 8));
            level.addFreshEntity((Entity)tnt);
        }
    }

    public static void explode(Level level, BlockPos pos, boolean immediately) {
        TntBarrelBlock.explode(level, pos, null, immediately);
    }

    private static void explode(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        TntBarrelBlock.explode(level, pos, entity, false);
    }

    private static void explode(Level level, BlockPos pos, @Nullable LivingEntity entity, boolean immediately) {
        if (!level.isClientSide) {
            PrimedTntBarrel tnt = TntBarrelBlock.createPrimedTntBarrel(level, pos, entity);
            if (immediately) {
                tnt.setFuse(0);
            }
            level.addFreshEntity((Entity)tnt);
            level.playSound(null, tnt.getX(), tnt.getY(), tnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)entity, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE)) {
            TntBarrelBlock.explode(level, pos, (LivingEntity)player);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            Item item = stack.getItem();
            if (!player.isCreative()) {
                if (stack.is(Items.FLINT_AND_STEEL)) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                } else {
                    stack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stack.is(Items.FIREWORK_ROCKET)) {
            Direction direction = hitResult.getDirection().getOpposite();
            if (!level.isClientSide) {
                FireworkRocketEntity firework = new FireworkRocketEntity(level, stack, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, true);
                ((FireworkRocketEntityAccessor)firework).setLifetime(80);
                Fireworks fireworks = (Fireworks)stack.get(DataComponents.FIREWORKS);
                if (fireworks != null) {
                    int offset = fireworks.flightDuration() - 1;
                    firework.shoot((double)direction.getStepX(), (double)direction.getStepY() + (double)offset * 0.125, (double)direction.getStepZ(), 0.5f, 1.0f);
                    level.addFreshEntity((Entity)firework);
                    PrimedTntBarrel tnt = TntBarrelBlock.createPrimedTntBarrel(level, pos, (LivingEntity)player);
                    tnt.startRiding((Entity)firework);
                    level.addFreshEntity((Entity)tnt);
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                    level.playSound(null, tnt.getX(), tnt.getY(), tnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.gameEvent((Entity)player, (Holder)GameEvent.PRIME_FUSE, pos);
                }
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private static PrimedTntBarrel createPrimedTntBarrel(Level level, BlockPos pos, LivingEntity owner) {
        return new PrimedTntBarrel(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, owner);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos pos = hitResult.getBlockPos();
            Entity entity = projectile.getOwner();
            if (projectile.isOnFire() && projectile.mayInteract(level, pos)) {
                LivingEntity living;
                TntBarrelBlock.explode(level, pos, entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
                level.removeBlock(pos, false);
            }
        }
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNSTABLE});
    }
}

